unit GestionDX;
// GestionDX.pas version 1.0.2 31/1/2
// Copyright (C) 2002 Clment Gatin - UB42

interface

uses DirectDraw,
     Forms,
     DDUtil,
     Windows,
     SysUtils;

var
  FDD  : IDirectDraw7;   //Objet DirectDraw7
  procedure ErrorOut(hRet : HRESULT; FuncName : string);  //procdure utilise pour afficher une bote de dialogue d'erreur en cas de problme avec DirectX.
  procedure InitDirectX; //Procdure d'initialisation de DirectX
  procedure ExitDirectX; //Procdure de dchargement de DirectX
implementation

procedure InitDirectX;
begin
  //Si vous utilisez des composants DirectX ncessitant un
  //chargement, vous pouvez mettre le code de chargement ici.
end;

procedure ErrorOut(hRet : HRESULT; FuncName : string);
var
  OutString : string;
begin
  //Affiche une bote de dialogue avec un code d'erreur.
  OutString := FuncName + ': ' + #13 + DDErrorString(hRet);
  Application.MessageBox(PChar(OutString), PChar(Application.Title), MB_OK or MB_ICONSTOP);
end;

procedure ExitDirectX;
begin
  //Si directDraw est utilis, on le dcharge.
  if Assigned(FDD) then
    FDD := nil;
end;

end.
